<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<title>ReadItem PHP Page</title>
		<style type="text/css">
			h1 {text-align: center; color: blue}
			h2 {font-family: Ariel, sans-serif; text-align: left; color: blue}
			p.footer {text-align: center}
			table.output {font-family: Ariel, sans-serif}
		</style>
	</head>
	<body>
	<?php
		// Get connection
		$Conn = odbc_connect('QACS', 'QACS-User','QACS-User+password');
	
		// Test connection
		if (!Conn)
	    	{
	        	exit ("ODBC Connection Failed: " . $Conn);
	    	}
		// Create SQL statement
    	$SQL = "SELECT * FROM ITEM";
 
    	// Execute SQL statement
    	$RecordSet = odbc_exec($Conn,$SQL);
    
    	// Test existence of recordset
    	if (!$RecordSet)
	    	{
	        	exit ("SQL Statement Error: " . $SQL);
	    	}
	?>
	    <!--  Page Headers -->
	    <h1>
	   		The Queen Anne Curiosity Shop ITEM Table
		</h1>
	    <hr />
	    <h2>
	        ITEM
		</h2>
	<?php	  
		// Table headers
	    echo "<table class='output' border='1'>
	    		<tr>
	    			<th>ItemID</th>
	    			<th>ItemDescription</th>
	    			<th>PurchaseDate</th>
	    			<th>ItemCost</th>
	    			<th>ItemPrice</th>
	    			<th>VendorID</th>
	    		</tr>";
	    
	    // Table data
	    while($RecordSetRow = odbc_fetch_array($RecordSet))
	    	{
	    	echo "<tr>";
	    	echo "<td>" . $RecordSetRow['ItemID'] . "</td>";
	    	echo "<td>" . $RecordSetRow['ItemDescription'] . "</td>";
	    	echo "<td>" . $RecordSetRow['PurchaseDate'] . "</td>";
	    	echo "<td>" . $RecordSetRow['ItemCost'] . "</td>";
	    	echo "<td>" . $RecordSetRow['ItemPrice'] . "</td>";
	    	echo "<td>" . $RecordSetRow['VendorID'] . "</td>";
	    	echo "</tr>";
	    	}
	    echo "</table>";
	    
	    // Close connection
	    odbc_close($Conn);
	?>
		<br />
		<hr />
		<p class="footer">
			<a href="../QACS/index.html">Return to The Queen Anne Curiosity Shop Home Page</a>
		</p>
		<hr />
    </body>
</html>