<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<title>ReadSalesperson PHP Page</title>
		<style type="text/css">
			h1 {text-align: center; color: blue}
			h2 {font-family: Ariel, sans-serif; text-align: left; color: blue}
			p.footer {text-align: center}
			table.output {font-family: Ariel, sans-serif}
		</style>
	</head>
	<body>
	<?php
		// Get connection
		$Conn = odbc_connect('WM', '', '');
	
		// Test connection
		if (!Conn)
	    	{
	        	exit ("ODBC Connection Failed: " . $Conn);
	    	}
		// Create SQL statement
    	$SQL = "SELECT * FROM SALESPERSON";
 
    	// Execute SQL statement
    	$RecordSet = odbc_exec($Conn,$SQL);
    
    	// Test existence of recordset
    	if (!$RecordSet)
	    	{
	        	exit ("SQL Statement Error: " . $SQL);
	    	}
	?>
	    <!--  Page Headers -->
	    <h1>
	   		The Wallingford Motors CRM SALESPERSON Table
		</h1>
	    <hr />
	    <h2>
	        SALESPERSON
		</h2>
	<?php	  
		// Table headers
	    echo "<table class='output' border='1'>
	    		<tr>
	    			<th>NickName</th>
	    			<th>LastName</th>
	    			<th>FirstName</th>
	    			<th>HireDate</th>
	    			<th>WageRate</th>
	    			<th>CommissionRate</th>
	    			<th>EmailAddress</th>
	    			<th>InventoryID</th>
	    		</tr>";
	    
	    // Table data
	    while($RecordSetRow = odbc_fetch_array($RecordSet))
	    	{
	    	echo "<tr>";
	    	echo "<td>" . $RecordSetRow['NickName'] . "</td>";
	    	echo "<td>" . $RecordSetRow['LastName'] . "</td>";
	    	echo "<td>" . $RecordSetRow['FirstName'] . "</td>";
	    	echo "<td>" . $RecordSetRow['HireDate'] . "</td>";
	    	echo "<td>" . $RecordSetRow['WageRate'] . "</td>";
	    	echo "<td>" . $RecordSetRow['CommissionRate'] . "</td>";
	    	echo "<td>" . $RecordSetRow['EmailAddress'] . "</td>";
	    	echo "<td>" . $RecordSetRow['InventoryID'] . "</td>";
	    	echo "</tr>";
	    	}
	    echo "</table>";
	    
	    // Close connection
	    odbc_close($Conn);
	?>
		<br />
		<hr />
		<p class="footer">
			<a href="../WM/index.html">Return to Wallingford Motors Home Page</a>
		</p>
		<hr />
    </body>
</html>