<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<title>ReadVehicle PHP Page</title>
		<style type="text/css">
			h1 {text-align: center; color: blue}
			h2 {font-family: Ariel, sans-serif; text-align: left; color: blue}
			p.footer {text-align: center}
			table.output {font-family: Ariel, sans-serif}
		</style>
	</head>
	<body>
	<?php
		// Get connection
		$Conn = odbc_connect('WM', '', '');
	
		// Test connection
		if (!Conn)
	    	{
	        	exit ("ODBC Connection Failed: " . $Conn);
	    	}
		// Create SQL statement
    	$SQL = "SELECT * FROM VEHICLE";
 
    	// Execute SQL statement
    	$RecordSet = odbc_exec($Conn,$SQL);
    
    	// Test existence of recordset
    	if (!$RecordSet)
	    	{
	        	exit ("SQL Statement Error: " . $SQL);
	    	}
	?>
	    <!--  Page Headers -->
	    <h1>
	   		The Wallingford Motors CRM VEHICLE Table
		</h1>
	    <hr />
	    <h2>
	        VEHICLE
		</h2>
	<?php	  
		// Table headers
	    echo "<table class='output' border='1'>
	    		<tr>
	    			<th>InventoryID</th>
	    			<th>Model</th>
	    			<th>VIN</th>
	    		</tr>";
	    
	    // Table data
	    while($RecordSetRow = odbc_fetch_array($RecordSet))
	    	{
	    	echo "<tr>";
	    	echo "<td>" . $RecordSetRow['InventoryID'] . "</td>";
	    	echo "<td>" . $RecordSetRow['Model'] . "</td>";
	    	echo "<td>" . $RecordSetRow['VIN'] . "</td>";
	    	echo "</tr>";
	    	}
	    echo "</table>";
	    
	    // Close connection
	    odbc_close($Conn);
	?>
		<br />
		<hr />
		<p class="footer">
			<a href="../WM/index.html">Return to Wallingford Motors Home Page</a>
		</p>
		<hr />
    </body>
</html>