#include	<windows.h>
#include	<math.h>
#include	<stdio.h>
#include	<process.h>
#include	<stdlib.h>

#define TRUE 1
#define FALSE 0
//#define DEBUG

static int runFlag = TRUE;

void main(int argc, char *argv[]) {
// Prototypes
	DWORD WINAPI threadWork(LPVOID);

// Local variables
	char c = 'n';
	HANDLE aThread;							// Child thread
	int i;
	int N;									// Number of threads
	unsigned int runTime;
	SYSTEMTIME now;
	WORD stopTimeMinute, stopTimeSecond;

// CreateThread (_beginthreadex) parameters
    LPSECURITY_ATTRIBUTES lpsa = NULL;		// default value
	DWORD cbStack = 0;						// default value
	DWORD fdwCreate = 0;		// Execute the thread immediately
	DWORD aThreadID;						// child's ID

// Get command line argument
	if(argc != 3) {
		printf("Usage: mthread <number_of_threads> <run_time_seconds>\n");
		exit(0);
	} else {
		N = atoi(argv[1]);
		runTime = atoi(argv[2]);
	}

// Determine time to halt
	GetSystemTime(&now);
	printf("mthread: Suite starting at system time %d:%d:%d\n",
		now.wHour, now.wMinute, now.wSecond);
	stopTimeSecond = (now.wSecond + (WORD) runTime) % 60;
	stopTimeMinute = now.wMinute + (now.wSecond + (WORD) runTime) / 60;
	
// Create N child thread
	for (i = 0; i < N; i++) {
		printf("mthread: Creating child thread[%d]\n",i);
		aThread = (HANDLE) _beginthreadex
			(
				(void *) lpsa,
				(unsigned) cbStack,
				(unsigned (_stdcall *)(void *)) threadWork,
				(void *) &i,
				(unsigned) fdwCreate,
				(unsigned *) &aThreadID
			);
		Sleep(100);		// Let this thread run
	}

// Cycle while children work ...
	while (runFlag) {
		GetSystemTime(&now);
		if ((now.wMinute >= stopTimeMinute)
			&&
			(now.wSecond >= stopTimeSecond)
			)
				runFlag = FALSE;
		Sleep(1000);
	}
	printf("mthread: Terminating at systen time %d:%d:%d\n",
			now.wHour, now.wMinute, now.wSecond);
	Sleep(5000);
	printf("mthread: Base thread & process terminated\n");
}


DWORD WINAPI threadWork(LPVOID threadNo) {
// Local variables
	double y;
	const double x = 3.14159;
	const double e = 2.7183;
	int me;
	int itCount;
	int i;
	const int napTime = 1000;				// in milliseconds
	const int busyTime = 40000;
	DWORD result = 0;

// Announce existence
	me = *((int *) threadNo);
	printf("mthread: Child thread[%d] alive\n", me);

// Create load according to parameters
	itCount = 0;
	while(runFlag) {
	// Parameterized CPU burst phase
		for(i = 0; i < busyTime; i++)
			y = pow(x, e);
	// Parameterized sleep phase
		Sleep(napTime);
	// Write record to stdout
#ifdef DEBUG
		printf("mthread: Child thread[%d] completed iteration %d\n",
				me, itCount++);
#endif
	}

// Terminating
	printf("cpuload: Child thread[%d] terminating\n", me);

	return result;
}
