% Analyzing Resistive Circuits Using MATLAB - ch3ex.m
%--------------------------------------------------------------
%  Vary the input voltage from 8 to 16 volts in 0.1 volt steps.
%--------------------------------------------------------------
Vs = 8:0.1:16;
%--------------------------------------------------------------
%           Enter values of the resistances.
%--------------------------------------------------------------
R1 = 1; R2 = 2; R3 = 3;       % series resistors, ohms
R4 = 6; R5 = 3; R6 = 2;       % parallel resistors, ohms
%--------------------------------------------------------------
%   Find the current, I,corresponding to each value of Vs.
%--------------------------------------------------------------
Rs = R1 + R2 + R3;                     % Equation 3.8-1
Rp = 1 / (1/R4 +1/R5 +1/R6);           % Equation 3.8-2

for k=1:length(Vs)
    VR(k) = Vs(k) * Rp / (Rp + Rs);    % Equation 3.8-3
    I(k)  = VR(k) / R6;                % Equation 3.8-4
end

%--------------------------------------------------------------
%                      Plot I versus Vs.
%--------------------------------------------------------------
plot(Vs, I)
grid
xlabel('Vs, V'), ylabel('I, A')
title('Current in R6')

